/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;

public class SAMPUtil {
    private SAMPUtil() {
    }

    protected static URL getURLForFile(File file) {
        try {
            URL u;
            String parentPath = file.getParentFile().getAbsolutePath();
            String filename = file.getName();
            if (parentPath.charAt(0) != '/') {
                parentPath = "/" + parentPath;
            }
            try {
                u = new URL("file://localhost" + parentPath.replaceAll(" ", "%20") + "/" + URLEncoder.encode(filename, "UTF-8").replaceAll("\\+", "%20"));
            }
            catch (UnsupportedEncodingException uee) {
                uee.printStackTrace();
                return null;
            }
            return u;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    protected static String sanitizeFilename(String fileName) {
        if (fileName == null) {
            return null;
        }
        return fileName.replaceAll("/", ".").replaceAll("[\\[|\\]]", " ").replaceAll(" ", "").replaceAll("\\+", "");
    }
}

